/*
 * Copyright (c) 2000-2001 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: sm_os_cygwin.h,v 1.12 2014/07/28 01:52:41 dboland Exp $
 */

/*
**  Platform definitions for Cygwin
*/

#define SM_OS_NAME	"cygwin"

/* to get version number */
/* #include <linux/version.h> */

# if !defined(KERNEL_VERSION)	/* not defined in 2.0.x kernel series */
#  define KERNEL_VERSION(a,b,c) (((a) << 16) + ((b) << 8) + (c))
# endif /* ! KERNEL_VERSION */

/* doesn't seem to work on Linux */
#ifndef SM_CONF_SETITIMER
# define SM_CONF_SETITIMER	0
#endif /* SM_CONF_SETITIMER */

#ifndef SM_CONF_SHM
# if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,2,19))
#  define SM_CONF_SHM	1
# endif /* LINUX_VERSION_CODE */
#endif /* SM_CONF_SHM */

#define SM_CONF_SYS_CDEFS_H	1
#ifndef SM_CONF_SEM
# define SM_CONF_SEM	2
#endif /* SM_CONF_SEM */
#ifndef SM_CONF_MSG
# define SM_CONF_MSG	1
#endif /* SM_CONF_MSG */

#define HASUNSETENV  1
#define ERRLIST_PREDEFINED            /* don't declare sys_errlist */
#define HASINITGROUPS 1       /* has initgroups(3) call */
#define _PATH_SENDMAILPID "/var/run/sendmail.pid"
#define USESETEUID    1       /* has usable seteuid(2) call */
#define HASFCHMOD     1       /* has fchmod(2) syscall */
#define HASFCHOWN     1       /* has fchown(2) syscall */
#define HASSETEGID 1       /* use setegid(2) to set saved gid */
#define HASURANDOMDEV      1       /* has /dev/urandom(4) */
